/*
  ack a list of alerts from cgi POST
*/
#include <stdio.h>
#include <assert.h>

#include "libfma.h"
#include "lf_alert.h"
#include "lf_fms.h"

#include "insist.h"
#include "fm_cgi_util.h"

int main (int argc, char*argv [])
{
  int i, n;
  int fms = -1;
  fm_cgi_form_t*f;

  lf_init();

  printf ("Content-type: text/html\n\n");

  f = fm_cgi_read_form ();
  insistf (f, ("error reading form"));
  
  e_w (("<html>"));
  e_w (("<head>"));
  e_w (("</head>"));
  e_w (("<body>"));
  
  fms = fm_cgi_connect_to_fms ();
  insistf (fms != -1, ("error connecting to fms"));


  for (n = i = 0; i < f->count; i++)
  {
    if (!strcmp (f->names [i], "id"))
    {
      int id = atoi (f->values [i]);
      n++;
      lf_ack_alert (fms, id);
    }
  }  

  e_w (("<p>acked %d alert%s\n", n, n == 1 ? "" : "s"));
  
  lf_fms_disconnect (fms);
  fm_cgi_free_form (f);

  e_w (("<body>"));
  e_w (("</html>"));  

  return 0;
  except: return 1;
}
